/*
 * DemoController.h
 *
 *  Created on: 08.03.2011
 *      Author: stefan.detter
 */

#ifndef DEMOCONTROLLER_H_
#define DEMOCONTROLLER_H_

#include <QObject>
#include <QMap>
#include <QAction>

#include <QrfeTraceModule>

#include <def.h>

class Tool;
class ModelData;
class ReaderControll;

class ToolController : public QObject, QrfeTraceModule
{
	Q_OBJECT
public:
	ToolController(ModelData* root, ReaderControll* readerControl, QWidget* parentWidget, QObject* parent = 0);
	virtual ~ToolController();

	QList<QString> 	availableTools ( );
	QList<QString> 	availableCustomTools ( );
	QList<QString> 	availableDemos ( );

	QList<QAction*> getToolActions ( );
	QList<QAction*> getCustomToolsActions ( );
	QList<QAction*> getDemoActions ( );


public slots:
	void 	permissionsChanged();
	void  	toolSelected();
	bool 	executeTool ( QString name );

signals:
	void 	customToolsChanged ( );
	void 	demosChanged ( );

signals:
	void 	appendGlobalJob(JobType type, const QList<QVariant>& params);

private:
	QAction*		createAction ( Tool* t );

private:
	ModelData* 				m_modelData;
	ReaderControll* 		m_readerControl;
	QWidget* 				m_parentWidget;

	QMap<QString, Tool*> 	m_tools;
	QMap<QString, Tool*> 	m_customTools;
	QMap<QString, Tool*> 	m_demos;

	QList<QAction*> 		m_toolActions;
	QList<QAction*> 		m_customToolsActions;
	QList<QAction*> 		m_demoActions;
};

#endif /* DEMOCONTROLLER_H_ */
